#include "stdafx.h"
#include "LF C DEMO.h"
#include "DlgContScan.h"


IMPLEMENT_DYNAMIC(CDlgContScan, CPropertyPage)

CDlgContScan::CDlgContScan()
	: CPropertyPage(CDlgContScan::IDD)
{
	m_hReader = NULL;
}

CDlgContScan::~CDlgContScan()
{
	if(m_hReader != NULL)
	{
		CloseReader(m_hReader);
	}
}

void CDlgContScan::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_CARD, m_ctrlCard);
	DDX_Control(pDX, IDC_BTN_CONT_SCAN, m_ctrlScan);
	DDX_Control(pDX, IDC_BTN_EXIT_SCAN, m_ctrlStop);
}


BEGIN_MESSAGE_MAP(CDlgContScan, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_CONT_SCAN, &CDlgContScan::OnBnClickedBtnContScan)
	ON_BN_CLICKED(IDC_BTN_EXIT_SCAN, &CDlgContScan::OnBnClickedBtnExitScan)
	ON_WM_TIMER()
END_MESSAGE_MAP()

BOOL CDlgContScan::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InsertColumn(0, _T("Card type"),		80	);
	InsertColumn(1, _T("Card id"),			120	);

	EnableBtn(TRUE);

	return TRUE;
}

void CDlgContScan::EnableBtn(BOOL bScan)
{
	m_ctrlScan.EnableWindow(bScan);
	m_ctrlStop.EnableWindow(!bScan);
}

void CDlgContScan::InsertColumn(UINT nCol, TCHAR* szData, UINT nMaxLen)
{
	if(szData != NULL)
	{
		LV_COLUMN stLvc;
		stLvc.mask		= LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
		stLvc.iSubItem	= nCol;
		stLvc.pszText	= szData;
		stLvc.cx		= nMaxLen;
		stLvc.fmt		= LVCFMT_LEFT;
		m_ctrlCard.InsertColumn(nCol, &stLvc);
		// m_ctrlData.SetColumnWidth( nCol, LVSCW_AUTOSIZE_USEHEADER);
	}
}

void CDlgContScan::InsertItem(UINT nIntem, UINT nSubItem, TCHAR* szString, UINT nImage)
{
	LVITEM stLvItem;
	::ZeroMemory(&stLvItem, sizeof(LVITEM));

	stLvItem.iItem = nIntem;
	stLvItem.iSubItem = nSubItem;
	stLvItem.mask = LVIF_TEXT | LVIF_STATE;
	if(nImage != -1)
	{
		stLvItem.mask |= LVIF_IMAGE;
		stLvItem.iImage	 = nImage;
	}
	stLvItem.pszText = szString;
	stLvItem.cchTextMax = (int)_tcslen(szString) + 1;

	if(nSubItem == 0x00)
	{
		// set the default count to 1 - in item data
		m_ctrlCard.InsertItem(&stLvItem);
	}

	if(nSubItem > 0x00)
		m_ctrlCard.SetItem(&stLvItem);
}

void CDlgContScan::OnBnClickedBtnContScan()
{
	m_ctrlCard.DeleteAllItems();
	if (m_rfidDriver.IsInstalled() && m_rfidDriver.IsEnabled())
	{
		m_hReader = OpenReader(m_rfidDriver.ComPort());
		if(m_hReader != NULL)
		{
			SetContinuesReadMode(m_hReader, 0x01);
			m_nTimer = SetTimer(1, 10, NULL); // each 10 ms
			EnableBtn(FALSE);
		}
	}
}

void CDlgContScan::OnBnClickedBtnExitScan()
{
	// TODO: Add your control notification handler code here
	EnableBtn(TRUE);
	KillTimer(m_nTimer);
	if(m_hReader != NULL)
	{
		SetContinuesReadMode(m_hReader, 0x00);
		CloseReader(m_hReader);
		m_hReader = NULL;
	}
}

void CDlgContScan::OnTimer(UINT_PTR nIDEvent)
{
	if(m_hReader != NULL)
	{
		BYTE pBuf[MAX_PATH]; UINT nSize = MAX_PATH;
		ZeroMemory(pBuf, nSize);

		UINT nCount = 10;
		USES_CONVERSION;
		while((nCount > 0x00) && (ReadContinuesModeData(m_hReader, pBuf, nSize) == ER_OK))
		{
			CString strType = _T("Unknown");
			switch(pBuf[0x00])
			{
				case 'h': strType = _T("Hitag1");	break;
				case 'H': strType = _T("Hitag2");	break;
				case 'Q': strType = _T("Q5");		break;
				case 'U': strType = _T("EM42XX");	break;
				case 'T': strType = _T("Titan");	break;
				case 'M': strType = _T("Temic");	break;
				case 'Z': strType = _T("ISO FDX");	break;
			}

			InsertItem(0, 0, (TCHAR*)(LPCTSTR)strType, -1);
			InsertItem(0, 1, A2T((CHAR*)pBuf + 0x01), -1);

			ZeroMemory(pBuf, nSize);
			nCount--;
		}
	}

	CPropertyPage::OnTimer(nIDEvent);
}
